
using System;
using System.Text;
using System.Collections;
using System.Text.RegularExpressions;
using NppScripts;

//SoldierEPilot 12-10-2014
//For non-commercial use only
public class Script : NppScript
{

 static public string GetSelectedText()
        {
            int start = (int)Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELECTIONSTART, 0, 0);
            int end = (int)Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELECTIONEND, 0, 0);
            var text = new StringBuilder(end - start + 1);
            Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_GETSELTEXT, 0, text);
            return text.ToString();
        }

static public void ReplaceSelection(string text)
        {
            Win32.SendMessage(Npp.CurrentScintilla, SciMsg.SCI_REPLACESEL, 0, text);
        }


// Remove strings like ""
 private static string NoPrivates(string s)
 {
   Regex rex=new Regex(@"",RegexOptions.IgnoreCase);
   s=rex.Replace(s,"");
   return(s);
 }

// Create correct "private" string
 private static string Privatization(string s)
 {
  MatchCollection MC=Regex.Matches(s, @"(?<!\w)[_][_a-zA-Z0-9]+");  
  ArrayList loc=new ArrayList();
  string prvt="private[";
  foreach (Match smc in MC)
   {
    string s2=("\"" +smc.Value+"\"").ToLower(); 
    if(!(loc.Contains(s2)))
      {
       loc.Add(s2);
       if ((smc.Value!="_this")&&(smc.Value!="_time"))
        {
          prvt=prvt+s2+", ";
        }
      }
   }
    if (prvt=="private[")
   {
      prvt="";
   }
   else
   {
     prvt=prvt.Substring(0,prvt.Length-2);   
     prvt=prvt+ "];";
   }
   return(prvt);
 }

 //Add string {} on the top of function listing
    public override void Run()
    {
	    string txt;
	    txt=GetSelectedText();
		if ((txt.Length)>0)
		{
		  //Add "private..." string on the top of selection
		  txt=Privatization(txt)+"\n"+NoPrivates(txt);
		  ReplaceSelection(txt);
		}
		else
		{
		//Nothing selected - "private..." string on the top of file
		  txt=Npp.GetAllText();
		  txt=Privatization(txt)+"\n"+NoPrivates(txt);
		  Npp.SetAllText(txt);
		}
    }
	
}